from copy import *
from laby import *
import os

# Recuperation du fichier texte contenant lelabyrinthe
labFile = input("Quel est le nom du fichier du labyrinthe ? ")
labPath = "./labs/" + labFile + ".txt"
assert os.path.isfile(labPath), "Le labyrinthe est introuvable! Vérifiez que le fichier .txt figure dans le dossier 'labs'"

# Creation d'un tableau correspondant au labyrinthe
with open(labPath) as f:
    liste = []
    line = f.readline().split("\n")[0]
    while line != "":
        liste.append([0 if x == " " else 1 if x == "#" else 2 if x == "D" else 3 for x in line])
        line = f.readline().split("\n")[0]
     
lab = Labyrinthe(liste)

# Creation d'une copie pour ne pas modifier le tableau d'origine
labcopy = deepcopy(lab)

# Recherche de la solution
lab.parcours(lab.depart()[0], lab.depart()[1], labcopy)

import pygame
from pygame.locals import *

## variables globales utiles au programme principal
tile_size = 30
screen_width, screen_height = tile_size*len(lab.tab[0])-1, tile_size*len(lab.tab)-1
    
pygame.init()
fenetre = pygame.display.set_mode((screen_width, screen_height))

# Chargement des textures du personnage
perso_bas = pygame.image.load("./resources/dk/dk_bas.png").convert_alpha()
perso_haut = pygame.image.load("./resources/dk/dk_haut.png").convert_alpha()
perso_droite = pygame.image.load("./resources/dk/dk_droit.png").convert_alpha()
perso_gauche = pygame.image.load("./resources/dk/dk_gauche.png").convert_alpha()

# Chargement des textures des cases
mur_tex = pygame.image.load("./resources/mur.png").convert_alpha()
depart_tex = pygame.image.load("./resources/depart.png").convert_alpha()
arrivee_tex = pygame.image.load("./resources/banane.png").convert_alpha()

# Creation de l'affichage du labyrinthe
for i in range(len(lab.tab)):
    for j in range(len(lab.tab[i])):
        if lab.tab[i][j] == 1: # 1 == mur
            fenetre.blit(mur_tex, (j*tile_size, i*tile_size))
        if lab.tab[i][j] == 2: # 2 == depart
            fenetre.blit(depart_tex, (j*tile_size, i*tile_size))
            fenetre.blit(perso_droite, (j*tile_size, i*tile_size))
        if lab.tab[i][j] == 3: # 3 == arrivee
            fenetre.blit(arrivee_tex, (j*tile_size, i*tile_size))


perso_droite.set_alpha(100)
perso_gauche.set_alpha(100)
perso_bas.set_alpha(100)
perso_haut.set_alpha(100)


# Affichage du chemin pris par l'IA
for i_case in range(len(lab.pile.pile)-1):
    if lab.pile.pile[i_case+1][1] < lab.pile.pile[i_case][1]:
        fenetre.blit(perso_gauche, (lab.pile.pile[i_case][1]*tile_size, lab.pile.pile[i_case][0]*tile_size))
    elif lab.pile.pile[i_case+1][1] > lab.pile.pile[i_case][1]:
        fenetre.blit(perso_droite, (lab.pile.pile[i_case][1]*tile_size, lab.pile.pile[i_case][0]*tile_size))
    elif lab.pile.pile[i_case+1][0] < lab.pile.pile[i_case][0]:
        fenetre.blit(perso_haut, (lab.pile.pile[i_case][1]*tile_size, lab.pile.pile[i_case][0]*tile_size))
    else:
        fenetre.blit(perso_bas, (lab.pile.pile[i_case][1]*tile_size, lab.pile.pile[i_case][0]*tile_size))    

#Rafraîchissement de l'écran
pygame.display.flip()

continuer = 1
while continuer:
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            continuer = 0
    
            
